import { Module } from '@nestjs/common';
import { MulterModule } from '@nestjs/platform-express';
import { memoryStorage } from 'multer';
import { StorageController } from './storage.controller';
import { StorageService } from './storage.service';
import { S3Provider } from './providers/s3.provider';
import { LocalStorageProvider } from './providers/local.provider';
import { CloudinaryProvider } from './providers/cloudinary.provider';
import { StorageProviderFactory } from './providers/storage.factory';
import { PrismaModule } from '../../common/prisma/prisma.module';

@Module({
  imports: [
    PrismaModule,
    MulterModule.register({
      storage: memoryStorage(),
      limits: {
        fileSize: 50 * 1024 * 1024, // 50MB max
      },
    }),
  ],
  controllers: [StorageController],
  providers: [
    StorageService,
    StorageProviderFactory,
    S3Provider,
    LocalStorageProvider,
    CloudinaryProvider,
  ],
  exports: [StorageService, StorageProviderFactory],
})
export class StorageModule {}
