import { IsString, IsNumber, IsOptional, Min } from 'class-validator';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class ValidatePromoDto {
  @ApiProperty({ description: 'Promo code to validate' })
  @IsString()
  code: string;

  @ApiProperty({ description: 'Order subtotal for validation' })
  @IsNumber()
  @Min(0)
  subtotal: number;

  @ApiPropertyOptional({ description: 'Vehicle type ID' })
  @IsOptional()
  @IsNumber()
  vehicleTypeId?: number;
}
