import { Module } from '@nestjs/common';
import { PaymentController } from './payment.controller';
import { PaymentService } from './payment.service';
import { StripeService } from './stripe.service';
import { PrismaModule } from '../../common/prisma/prisma.module';
import {
  GatewayFactory,
  StripeGateway,
  FlutterwaveGateway,
  CinetPayGateway,
  PayDunyaGateway,
  MpesaGateway,
  PaystackGateway,
  WaveGateway,
  OrangeMoneyGateway,
} from './gateways';

@Module({
  imports: [PrismaModule],
  controllers: [PaymentController],
  providers: [
    PaymentService,
    StripeService,
    // Gateways
    GatewayFactory,
    StripeGateway,
    FlutterwaveGateway,
    CinetPayGateway,
    PayDunyaGateway,
    MpesaGateway,
    PaystackGateway,
    WaveGateway,
    OrangeMoneyGateway,
  ],
  exports: [PaymentService, StripeService, GatewayFactory],
})
export class PaymentModule {}
