import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { IsInt, IsString, IsOptional } from 'class-validator';

export class ProcessPaymentDto {
  @ApiProperty({ example: 1 })
  @IsInt()
  booking_id: number;

  @ApiProperty({ example: 'card', description: 'cash, card, wallet, mobile_money' })
  @IsString()
  payment_method: string;

  @ApiPropertyOptional({ example: 1, description: 'Card ID for card payments' })
  @IsOptional()
  @IsInt()
  card_id?: number;
}
