import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { NotificationService } from './notification.service';
import { FirebaseService } from './firebase.service';
import { SmsService } from './sms.service';
import { WhatsAppService } from './whatsapp.service';
import { OneSignalService } from './onesignal.service';
import { PusherService } from './pusher.service';
import { PrismaModule } from '../../shared/database/prisma.module';

@Module({
  imports: [ConfigModule, PrismaModule],
  providers: [
    NotificationService,
    FirebaseService,
    SmsService,
    WhatsAppService,
    OneSignalService,
    PusherService,
  ],
  exports: [
    NotificationService,
    FirebaseService,
    SmsService,
    WhatsAppService,
    OneSignalService,
    PusherService,
  ],
})
export class NotificationModule {}
