import { Module, Global } from '@nestjs/common';
import { I18nService } from './i18n.service';
import { TranslationService } from './translation.service';
import { I18nController } from './i18n.controller';
import { PrismaModule } from '../../common/prisma/prisma.module';

@Global()
@Module({
  imports: [PrismaModule],
  controllers: [I18nController],
  providers: [I18nService, TranslationService],
  exports: [I18nService, TranslationService],
})
export class I18nModule {}
