import { Module } from '@nestjs/common';
import { GeocodingController } from './geocoding.controller';
import { GeocodingService } from './geocoding.service';
import { GoogleMapsProvider } from './providers/google-maps.provider';
import { OpenStreetMapProvider } from './providers/openstreetmap.provider';
import { GeocodingProviderFactory } from './providers/provider.factory';
import { DistanceService } from './distance.service';
import { PrismaModule } from '../../common/prisma/prisma.module';

@Module({
  imports: [PrismaModule],
  controllers: [GeocodingController],
  providers: [
    GeocodingService,
    DistanceService,
    GeocodingProviderFactory,
    GoogleMapsProvider,
    OpenStreetMapProvider,
  ],
  exports: [GeocodingService, DistanceService],
})
export class GeocodingModule {}
