import { ApiProperty } from '@nestjs/swagger';
import { IsInt, Min, Max } from 'class-validator';

export class UpdateStatusDto {
  @ApiProperty({ example: 1, description: '1=Online, 2=Offline' })
  @IsInt()
  @Min(1)
  @Max(2)
  is_online: number;
}
