import { Module, forwardRef } from '@nestjs/common';
import { DriverController } from './driver.controller';
import { DriverService } from './driver.service';
import { DriverAssignmentService } from './driver-assignment.service';
import { PrismaModule } from '../../common/prisma/prisma.module';
import { WebsocketModule } from '../websocket/websocket.module';
import { QueueModule } from '../queue/queue.module';

@Module({
  imports: [
    PrismaModule,
    forwardRef(() => WebsocketModule),
    forwardRef(() => QueueModule),
  ],
  controllers: [DriverController],
  providers: [DriverService, DriverAssignmentService],
  exports: [DriverService, DriverAssignmentService],
})
export class DriverModule {}
