import {
  IsNumber,
  IsOptional,
  IsBoolean,
  IsString,
  IsEnum,
  Min,
} from 'class-validator';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class EstimateDeliveryDto {
  @ApiProperty({ description: 'Pickup latitude' })
  @IsNumber()
  pickupLatitude: number;

  @ApiProperty({ description: 'Pickup longitude' })
  @IsNumber()
  pickupLongitude: number;

  @ApiProperty({ description: 'Drop latitude' })
  @IsNumber()
  dropLatitude: number;

  @ApiProperty({ description: 'Drop longitude' })
  @IsNumber()
  dropLongitude: number;

  @ApiPropertyOptional({ description: 'Package weight in kg' })
  @IsOptional()
  @IsNumber()
  @Min(0)
  packageWeight?: number;

  @ApiPropertyOptional({
    description: 'Package size',
    enum: ['small', 'medium', 'large', 'extra_large'],
  })
  @IsOptional()
  @IsEnum(['small', 'medium', 'large', 'extra_large'])
  packageSize?: 'small' | 'medium' | 'large' | 'extra_large';

  @ApiPropertyOptional({ description: 'Is package fragile' })
  @IsOptional()
  @IsBoolean()
  isFragile?: boolean;

  @ApiPropertyOptional({ description: 'Declared value for insurance' })
  @IsOptional()
  @IsNumber()
  @Min(0)
  declaredValue?: number;

  @ApiPropertyOptional({ description: 'Vehicle type ID' })
  @IsOptional()
  @IsNumber()
  vehicleTypeId?: number;

  @ApiPropertyOptional({ description: 'Promo code' })
  @IsOptional()
  @IsString()
  promoCode?: string;
}
