import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { IsNumber, IsOptional, IsInt, IsString, Min } from 'class-validator';

export class EstimateBookingDto {
  @ApiProperty({ example: 6.1725, description: 'Pickup latitude' })
  @IsNumber()
  pickup_latitude: number;

  @ApiProperty({ example: 1.2314, description: 'Pickup longitude' })
  @IsNumber()
  pickup_longitude: number;

  @ApiProperty({ example: 6.1825, description: 'Drop latitude' })
  @IsNumber()
  drop_latitude: number;

  @ApiProperty({ example: 1.2414, description: 'Drop longitude' })
  @IsNumber()
  drop_longitude: number;

  @ApiProperty({ example: 1, description: 'Vehicle type ID' })
  @IsInt()
  @Min(1)
  vehicle_type_id: number;

  @ApiPropertyOptional({ example: 'PROMO123', description: 'Promo code for discount' })
  @IsOptional()
  @IsString()
  promo_code?: string;

  @ApiPropertyOptional({ example: 1, description: 'Promo code ID' })
  @IsOptional()
  @IsInt()
  promo_code_id?: number;
}

/**
 * Response DTO for fare estimate
 */
export class EstimateResponseDto {
  distance: number;
  estimated_time: number;
  base_fare: number;
  distance_fare: number;
  time_fare: number;
  surge_multiplier: number;
  surge_amount: number;
  sub_total: number;
  tax_amount: number;
  total_fare: number;
  min_fare: number;
  currency: string;
  vehicle_type_id: number;
  discount_amount?: number;
  promo_applied?: boolean;
}
