import { ApiPropertyOptional } from '@nestjs/swagger';
import { IsString, IsOptional, IsInt } from 'class-validator';

export class CancelBookingDto {
  @ApiPropertyOptional({ example: 1, description: 'Cancellation reason ID' })
  @IsOptional()
  @IsInt()
  reason_id?: number;

  @ApiPropertyOptional({ example: 'Driver took too long' })
  @IsOptional()
  @IsString()
  reason_text?: string;
}
