import { Injectable, UnauthorizedException } from '@nestjs/common';
import { PassportStrategy } from '@nestjs/passport';
import { Strategy } from 'passport-local';
import * as bcrypt from 'bcrypt';
import { PrismaService } from '../../../common/prisma/prisma.service';

@Injectable()
export class LocalStrategy extends PassportStrategy(Strategy) {
  constructor(private prisma: PrismaService) {
    super({
      usernameField: 'email_or_phone',
      passwordField: 'password',
      passReqToCallback: true,
    });
  }

  async validate(req: any, emailOrPhone: string, password: string): Promise<any> {
    const merchantId = req.body.merchant_id || req.query.merchant_id;
    const userType = req.body.user_type || 'user';

    let entity: any;

    if (userType === 'driver') {
      entity = await this.prisma.driver.findFirst({
        where: {
          merchant_id: parseInt(merchantId),
          OR: [
            { email: emailOrPhone },
            { phoneNumber: emailOrPhone },
          ],
        },
      });
    } else {
      entity = await this.prisma.user.findFirst({
        where: {
          merchant_id: parseInt(merchantId),
          user_delete: null,
          OR: [
            { email: emailOrPhone },
            { UserPhone: emailOrPhone },
          ],
        },
      });
    }

    if (!entity) {
      throw new UnauthorizedException('Invalid credentials');
    }

    const isPasswordValid = await bcrypt.compare(password, entity.password);
    if (!isPasswordValid) {
      throw new UnauthorizedException('Invalid credentials');
    }

    const { password: _, otp, otp_expires_at, ...result } = entity;
    return result;
  }
}
