import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { IsString, IsOptional, IsInt } from 'class-validator';

export class UserLoginDto {
  @ApiProperty({ example: 'john@example.com', description: 'Email or phone number' })
  @IsString()
  email_or_phone: string;

  @ApiProperty({ example: 'password123' })
  @IsString()
  password: string;

  @ApiPropertyOptional({ example: 1, description: '1=Android, 2=iOS' })
  @IsOptional()
  @IsInt()
  device_type?: number;

  @ApiPropertyOptional({ example: 'player_id_123' })
  @IsOptional()
  @IsString()
  player_id?: string;
}
