import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { IsString, IsOptional, IsInt, Length } from 'class-validator';

export class OtpDto {
  @ApiProperty({ example: 'john@example.com', description: 'Email or phone number' })
  @IsString()
  email_or_phone: string;

  @ApiProperty({ example: '123456', description: '6-digit OTP code' })
  @IsString()
  @Length(6, 6)
  otp: string;

  @ApiPropertyOptional({ example: 1, description: '1=Android, 2=iOS' })
  @IsOptional()
  @IsInt()
  device_type?: number;

  @ApiPropertyOptional({ example: 'player_id_123' })
  @IsOptional()
  @IsString()
  player_id?: string;
}
