import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import {
  IsString,
  IsEmail,
  IsOptional,
  MinLength,
  IsInt,
  Matches,
} from 'class-validator';

export class DriverSignupDto {
  @ApiProperty({ example: 'John' })
  @IsString()
  first_name: string;

  @ApiProperty({ example: 'Doe' })
  @IsString()
  last_name: string;

  @ApiPropertyOptional({ example: 'driver@example.com' })
  @IsOptional()
  @IsEmail()
  email?: string;

  @ApiPropertyOptional({ example: '+22890123456' })
  @IsOptional()
  @IsString()
  @Matches(/^[0-9+]+$/, { message: 'Invalid phone number format' })
  phone?: string;

  @ApiProperty({ example: 'password123' })
  @IsString()
  @MinLength(6)
  password: string;

  @ApiPropertyOptional({ example: 1, description: '1=Android, 2=iOS' })
  @IsOptional()
  @IsInt()
  device_type?: number;

  @ApiPropertyOptional({ example: 'player_id_123' })
  @IsOptional()
  @IsString()
  player_id?: string;

  @ApiPropertyOptional({ example: 'REF12345' })
  @IsOptional()
  @IsString()
  referral_code?: string;
}
