import { Module } from '@nestjs/common';
import { AnalyticsController } from './analytics.controller';
import { AnalyticsService } from './analytics.service';
import { MetricsService } from './metrics.service';
import { RealtimeAnalyticsService } from './realtime.service';
import { PrismaModule } from '../../common/prisma/prisma.module';

@Module({
  imports: [PrismaModule],
  controllers: [AnalyticsController],
  providers: [
    AnalyticsService,
    MetricsService,
    RealtimeAnalyticsService,
  ],
  exports: [AnalyticsService, MetricsService, RealtimeAnalyticsService],
})
export class AnalyticsModule {}
