import { createParamDecorator, ExecutionContext } from '@nestjs/common';

/**
 * Decorator pour extraire merchant_id de la requete
 *
 * Usage:
 * @Get('config')
 * getConfig(@MerchantId() merchantId: number) { ... }
 */
export const MerchantId = createParamDecorator(
  (data: unknown, ctx: ExecutionContext): number => {
    const request = ctx.switchToHttp().getRequest();
    return request.merchantId;
  },
);

/**
 * Decorator pour extraire l'utilisateur connecte
 *
 * Usage:
 * @Get('profile')
 * getProfile(@CurrentUser() user: User) { ... }
 */
export const CurrentUser = createParamDecorator(
  (data: string, ctx: ExecutionContext) => {
    const request = ctx.switchToHttp().getRequest();
    const user = request.user;

    return data ? user?.[data] : user;
  },
);
