-- Table: wallet_recharges
-- User wallet recharge transactions with bonus tracking and loyalty integration

CREATE TABLE `wallet_recharges` (
  `id` bigint UNSIGNED NOT NULL,
  `user_id` int UNSIGNED NOT NULL,
  `merchant_id` int UNSIGNED NOT NULL,
  `campaign_id` bigint UNSIGNED DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL,
  `bonus_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_credited` decimal(15,2) NOT NULL,
  `bonus_percent` decimal(5,2) NOT NULL DEFAULT '0.00',
  `points_earned` int NOT NULL DEFAULT '0',
  `level_at_recharge` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `level_multiplier` decimal(5,2) NOT NULL DEFAULT '1.00',
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_reference` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_provider` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_details` json DEFAULT NULL,
  `is_auto_recharge` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('pending','completed','failed','refunded') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Primary key and indexes would be added via ALTER TABLE statements
