-- Table: surge_zones
-- Geographic zones for surge pricing with polygon or radius-based boundaries

CREATE TABLE `surge_zones` (
  `id` bigint UNSIGNED NOT NULL,
  `merchant_id` int UNSIGNED NOT NULL,
  `country_id` int UNSIGNED NOT NULL,
  `country_area_id` int UNSIGNED DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `polygon_coordinates` json DEFAULT NULL,
  `center_lat` decimal(10,7) DEFAULT NULL,
  `center_lng` decimal(10,7) DEFAULT NULL,
  `radius_km` decimal(8,2) NOT NULL DEFAULT '5.00',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `is_dynamic` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Primary key and indexes would be added via ALTER TABLE statements
