-- Table: referral_systems
-- Referral program configurations with offer types and conditions

CREATE TABLE `referral_systems` (
  `id` int UNSIGNED NOT NULL,
  `merchant_id` int UNSIGNED DEFAULT NULL,
  `country_id` int UNSIGNED DEFAULT NULL,
  `country_area_id` int UNSIGNED DEFAULT NULL,
  `application` int NOT NULL COMMENT '1-User,2-Driver',
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `offer_condition` int NOT NULL COMMENT '0 : Unlimited,1 : Limited',
  `offer_applicable` int NOT NULL COMMENT '1: Sender, 2: Receiver, 3: Both',
  `offer_type` int NOT NULL,
  `offer_value` decimal(10,2) NOT NULL,
  `maximum_offer_amount` int DEFAULT NULL,
  `offer_condition_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Required json data for condition',
  `status` int NOT NULL DEFAULT '1' COMMENT '1-Active, 2-Inactive, 3-Expired,4-Deleted',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Primary key and indexes would be added via ALTER TABLE statements
