CREATE TABLE `promo_codes` (
  `id` int UNSIGNED NOT NULL,
  `merchant_id` int UNSIGNED DEFAULT NULL,
  `segment_id` int UNSIGNED DEFAULT NULL,
  `country_area_id` int UNSIGNED DEFAULT NULL,
  `corporate_id` int UNSIGNED DEFAULT NULL,
  `promoCode` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `promocode_without_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `promocode_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `promo_code_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `promo_code_value` int NOT NULL,
  `promo_code_without_value` int NOT NULL,
  `promo_code_value_type` int NOT NULL,
  `promo_code_validity` int NOT NULL,
  `promo_code_limit` int NOT NULL,
  `promo_code_limit_per_user` int NOT NULL,
  `promo_percentage_maximum_discount` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_minimum_amount` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'order''s minimum amount to get coupon discount',
  `min_rides_count` int DEFAULT NULL COMMENT 'Nombre minimum de courses précédentes requises',
  `max_rides_count` int DEFAULT NULL COMMENT 'Nombre maximum de courses (pour cibler les nouveaux)',
  `min_total_spent` decimal(12,2) DEFAULT NULL COMMENT 'Montant total minimum dépensé par le client',
  `apply_on_nth_ride` int DEFAULT NULL COMMENT 'Appliquer uniquement sur la Nième course (ex: 5 = 5ème course)',
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `valid_from_time` time DEFAULT NULL COMMENT 'Heure de début de validité (ex: 18:00 pour happy hour)',
  `valid_to_time` time DEFAULT NULL COMMENT 'Heure de fin de validité',
  `valid_days` json DEFAULT NULL COMMENT 'Jours valides: 1=lundi...7=dimanche, null=tous les jours',
  `end_date_without_string` date DEFAULT NULL,
  `applicable_for` int NOT NULL,
  `target_type` tinyint NOT NULL DEFAULT '1' COMMENT '1=tous, 2=nouveaux, 3=corporate, 4=groupe, 5=liste_cibles, 6=conditions',
  `target_group_id` bigint UNSIGNED DEFAULT NULL,
  `is_combinable` tinyint NOT NULL DEFAULT '0' COMMENT '1=cumulable avec autres promos, 0=non cumulable',
  `promo_code_status` int NOT NULL DEFAULT '1',
  `priority` int NOT NULL DEFAULT '0' COMMENT 'Plus élevé = plus prioritaire',
  `auto_notify` tinyint NOT NULL DEFAULT '0' COMMENT '1=notifier automatiquement les cibles',
  `promo_code_status_without_string` int NOT NULL DEFAULT '1',
  `deleted` int DEFAULT NULL,
  `status` int NOT NULL DEFAULT '1' COMMENT '1:Active, 2: Inactive 3: Expired',
  `visibility` tinyint NOT NULL DEFAULT '1' COMMENT '1=public, 2=privé (code manuel), 3=semi-privé (visible que pour cibles)',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vehicle_type` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
