CREATE TABLE `drivers` (
  `id` int UNSIGNED NOT NULL,
  `merchant_driver_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `merchant_id` int UNSIGNED DEFAULT NULL,
  `last_bill_generated` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_mode` tinyint NOT NULL DEFAULT '2' COMMENT '1:Subscription Based 2:Commission Based\r\nen français\r\n1: sur abonnement\r\n2: sur commission',
  `taxi_company_id` int UNSIGNED DEFAULT NULL,
  `unique_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `driver_gender` int DEFAULT NULL COMMENT '1 for male and 2 for female',
  `rider_gender_choice` tinyint NOT NULL DEFAULT '0' COMMENT '0 :All,1 :Male,2 :Female',
  `first_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `whatsapp_notifications` tinyint(1) NOT NULL DEFAULT '1',
  `whatsapp_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `home_location_active` int DEFAULT '2' COMMENT '1:Enable  2:Disable',
  `pool_ride_active` int NOT NULL DEFAULT '2',
  `status_for_pool` int NOT NULL DEFAULT '1',
  `avail_seats` int DEFAULT NULL,
  `occupied_seats` int DEFAULT NULL,
  `pick_exceed` int DEFAULT NULL,
  `pool_user_id` int DEFAULT NULL,
  `phoneNumber` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `face_recognition_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `wallet_money` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_trips` int DEFAULT NULL,
  `total_earnings` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_comany_earning` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `outstand_amount` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_latitude` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_longitude` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_location_update_time` datetime DEFAULT NULL,
  `bearing` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `accuracy` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `device` tinyint DEFAULT NULL COMMENT '1:Android, 2:iOS ',
  `fcm_device_token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `player_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rating` decimal(10,1) DEFAULT '5.0',
  `country_area_id` int UNSIGNED DEFAULT NULL,
  `login_logout` int NOT NULL DEFAULT '2',
  `online_offline` int NOT NULL DEFAULT '2',
  `free_busy` int NOT NULL DEFAULT '2',
  `bank_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_holder_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `routing_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_type_id` int UNSIGNED DEFAULT NULL COMMENT '1:Saving 2:Current 3:Recurring Deposit Account 4:basic checking accounts',
  `driver_verify_status` int NOT NULL DEFAULT '1',
  `signupFrom` int NOT NULL DEFAULT '1',
  `signupStep` int NOT NULL DEFAULT '1',
  `driver_verification_date` datetime DEFAULT NULL,
  `driver_admin_status` int NOT NULL DEFAULT '1',
  `access_token_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `driver_delete` int DEFAULT NULL,
  `online_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_ride_request_timestamp` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `driver_referralcode` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `driver_block_status` int DEFAULT NULL,
  `block_reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Raison du blocage du chauffeur',
  `blocked_at` timestamp NULL DEFAULT NULL COMMENT 'Date et heure de blocage',
  `term_status` int DEFAULT '0',
  `pending_document_status` int DEFAULT '2',
  `admin_msg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `temp_admin_msg` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fullName` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reject_driver` int DEFAULT '1',
  `driver_cpf_number` varchar(6555) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agency_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `driver_additional_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `app_debug_mode` tinyint DEFAULT '2',
  `country_id` int UNSIGNED DEFAULT NULL,
  `ats_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Apporio tracking system id for socket',
  `language` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'fr',
  `segment_group_id` int UNSIGNED DEFAULT NULL,
  `reward_points` double NOT NULL DEFAULT '0',
  `usable_reward_points` double NOT NULL DEFAULT '0',
  `use_reward_trip_count` int UNSIGNED NOT NULL DEFAULT '0',
  `is_suspended` timestamp NULL DEFAULT NULL,
  `network_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referred_by` int UNSIGNED DEFAULT NULL,
  `sc_address_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'pending, rejected, verified',
  `sc_identity_photo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'stripe connect identity photo',
  `sc_identity_photo_status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'pending , verified, rejected',
  `ssn` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_ip` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'ip while registering',
  `sc_account_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'stripe connect account id',
  `sc_account_status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'active, rejected, pending',
  `bsb_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abn_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_account_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Paystack split account id',
  `paystack_account_status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'active, rejected, pending',
  `driver_agency_id` int UNSIGNED DEFAULT NULL,
  `float_managers_id` int DEFAULT NULL,
  `commission` int DEFAULT NULL,
  `can_transfer` tinyint(1) DEFAULT NULL,
  `can_withdraw` tinyint(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
