# Configuration MonkAPI

## Variables d'environnement

Toutes les configurations se font via variables d'environnement. Copier `.env.example` vers `.env` et adapter.

```bash
cp .env.example .env
```

## Application

| Variable | Description | Defaut | Requis |
|----------|-------------|--------|--------|
| `NODE_ENV` | Environnement | `development` | Non |
| `PORT` | Port du serveur | `3000` | Non |
| `API_VERSION` | Version API | `v1` | Non |
| `API_PREFIX` | Prefixe API | `api` | Non |
| `APP_URL` | URL de l'application | - | Oui |
| `FRONTEND_URL` | URL du frontend | - | Non |

```env
NODE_ENV=production
PORT=3000
API_VERSION=v1
API_PREFIX=api
APP_URL=https://api.monkapi.com
FRONTEND_URL=https://app.monkapi.com
```

## Base de donnees

| Variable | Description | Defaut | Requis |
|----------|-------------|--------|--------|
| `DATABASE_URL` | URL de connexion MySQL | - | Oui |
| `DATABASE_POOL_MIN` | Connexions min | `2` | Non |
| `DATABASE_POOL_MAX` | Connexions max | `10` | Non |
| `DATABASE_LOG_QUERIES` | Logger les requetes | `false` | Non |
| `DATABASE_SLOW_QUERY_MS` | Seuil requete lente | `1000` | Non |

```env
DATABASE_URL="mysql://user:password@localhost:3306/monkapi"
DATABASE_POOL_MIN=2
DATABASE_POOL_MAX=10
DATABASE_LOG_QUERIES=false
DATABASE_SLOW_QUERY_MS=1000
```

### Format URL

```
mysql://[user]:[password]@[host]:[port]/[database]?[options]
```

Options courantes:
- `connection_limit=10`
- `pool_timeout=10`

## Redis

| Variable | Description | Defaut | Requis |
|----------|-------------|--------|--------|
| `REDIS_HOST` | Hote Redis | `localhost` | Oui |
| `REDIS_PORT` | Port Redis | `6379` | Non |
| `REDIS_PASSWORD` | Mot de passe | - | Non |
| `REDIS_DB` | Numero de base | `0` | Non |
| `REDIS_URL` | URL complete | - | Non |
| `REDIS_KEY_PREFIX` | Prefixe des cles | `monkapi:` | Non |

```env
REDIS_HOST=localhost
REDIS_PORT=6379
REDIS_PASSWORD=
REDIS_DB=0
REDIS_KEY_PREFIX=monkapi:
```

Ou avec URL:

```env
REDIS_URL=redis://:password@localhost:6379/0
```

## JWT / Authentification

| Variable | Description | Defaut | Requis |
|----------|-------------|--------|--------|
| `JWT_SECRET` | Secret JWT | - | Oui |
| `JWT_EXPIRES_IN` | Expiration access token | `7d` | Non |
| `JWT_REFRESH_SECRET` | Secret refresh token | - | Oui |
| `JWT_REFRESH_EXPIRES_IN` | Expiration refresh | `30d` | Non |
| `OTP_EXPIRES_IN` | Expiration OTP (sec) | `300` | Non |
| `OTP_LENGTH` | Longueur OTP | `6` | Non |

```env
JWT_SECRET=your-super-secret-key-minimum-32-characters
JWT_EXPIRES_IN=7d
JWT_REFRESH_SECRET=your-refresh-secret-key-minimum-32-characters
JWT_REFRESH_EXPIRES_IN=30d
OTP_EXPIRES_IN=300
OTP_LENGTH=6
```

**Important**: Utiliser des secrets forts (minimum 32 caracteres) en production.

## Stripe

| Variable | Description | Requis |
|----------|-------------|--------|
| `STRIPE_SECRET_KEY` | Cle secrete API | Oui |
| `STRIPE_PUBLISHABLE_KEY` | Cle publique | Non |
| `STRIPE_WEBHOOK_SECRET` | Secret webhook | Oui |
| `STRIPE_API_VERSION` | Version API | Non |

```env
STRIPE_SECRET_KEY=sk_test_xxx
STRIPE_PUBLISHABLE_KEY=pk_test_xxx
STRIPE_WEBHOOK_SECRET=whsec_xxx
STRIPE_API_VERSION=2023-10-16
```

## Firebase (FCM)

| Variable | Description | Requis |
|----------|-------------|--------|
| `FIREBASE_PROJECT_ID` | ID du projet | Oui |
| `FIREBASE_PRIVATE_KEY` | Cle privee | Oui |
| `FIREBASE_CLIENT_EMAIL` | Email client | Oui |

```env
FIREBASE_PROJECT_ID=your-project-id
FIREBASE_PRIVATE_KEY="-----BEGIN PRIVATE KEY-----\n...\n-----END PRIVATE KEY-----\n"
FIREBASE_CLIENT_EMAIL=firebase-adminsdk@project.iam.gserviceaccount.com
```

## OneSignal

| Variable | Description | Requis |
|----------|-------------|--------|
| `ONESIGNAL_APP_ID` | ID application | Oui |
| `ONESIGNAL_API_KEY` | Cle API | Oui |

```env
ONESIGNAL_APP_ID=xxx-xxx-xxx
ONESIGNAL_API_KEY=xxx
```

## SMS (Twilio)

| Variable | Description | Requis |
|----------|-------------|--------|
| `TWILIO_ACCOUNT_SID` | SID du compte | Oui |
| `TWILIO_AUTH_TOKEN` | Token auth | Oui |
| `TWILIO_PHONE_NUMBER` | Numero expediteur | Oui |

```env
TWILIO_ACCOUNT_SID=ACxxx
TWILIO_AUTH_TOKEN=xxx
TWILIO_PHONE_NUMBER=+1234567890
```

## Email (SMTP)

| Variable | Description | Defaut | Requis |
|----------|-------------|--------|--------|
| `MAIL_HOST` | Serveur SMTP | - | Oui |
| `MAIL_PORT` | Port SMTP | `587` | Non |
| `MAIL_USER` | Utilisateur | - | Oui |
| `MAIL_PASSWORD` | Mot de passe | - | Oui |
| `MAIL_FROM_NAME` | Nom expediteur | `MonkAPI` | Non |
| `MAIL_FROM_ADDRESS` | Email expediteur | - | Oui |
| `MAIL_SECURE` | TLS | `false` | Non |

```env
MAIL_HOST=smtp.mailgun.org
MAIL_PORT=587
MAIL_USER=postmaster@mg.monkapi.com
MAIL_PASSWORD=xxx
MAIL_FROM_NAME=MonkAPI
MAIL_FROM_ADDRESS=noreply@monkapi.com
MAIL_SECURE=false
```

## AWS S3 (Stockage)

| Variable | Description | Requis |
|----------|-------------|--------|
| `AWS_ACCESS_KEY_ID` | Access key | Oui |
| `AWS_SECRET_ACCESS_KEY` | Secret key | Oui |
| `AWS_REGION` | Region | Oui |
| `AWS_S3_BUCKET` | Nom du bucket | Oui |
| `AWS_S3_URL` | URL publique | Non |

```env
AWS_ACCESS_KEY_ID=AKIA...
AWS_SECRET_ACCESS_KEY=xxx
AWS_REGION=eu-west-1
AWS_S3_BUCKET=monkapi-uploads
AWS_S3_URL=https://monkapi-uploads.s3.eu-west-1.amazonaws.com
```

## Google Maps

| Variable | Description | Requis |
|----------|-------------|--------|
| `GOOGLE_MAPS_API_KEY` | Cle API | Oui |

```env
GOOGLE_MAPS_API_KEY=AIza...
```

## Social Login

### Google

| Variable | Description |
|----------|-------------|
| `GOOGLE_CLIENT_ID` | Client ID |
| `GOOGLE_CLIENT_SECRET` | Client secret |

### Facebook

| Variable | Description |
|----------|-------------|
| `FACEBOOK_APP_ID` | App ID |
| `FACEBOOK_APP_SECRET` | App secret |

### Apple

| Variable | Description |
|----------|-------------|
| `APPLE_CLIENT_ID` | Client ID |
| `APPLE_TEAM_ID` | Team ID |
| `APPLE_KEY_ID` | Key ID |
| `APPLE_PRIVATE_KEY` | Private key |

```env
GOOGLE_CLIENT_ID=xxx.apps.googleusercontent.com
GOOGLE_CLIENT_SECRET=xxx

FACEBOOK_APP_ID=xxx
FACEBOOK_APP_SECRET=xxx

APPLE_CLIENT_ID=com.monkapi.app
APPLE_TEAM_ID=xxx
APPLE_KEY_ID=xxx
APPLE_PRIVATE_KEY="-----BEGIN PRIVATE KEY-----\n...\n-----END PRIVATE KEY-----"
```

## Queues (BullMQ)

| Variable | Description | Defaut |
|----------|-------------|--------|
| `QUEUE_PREFIX` | Prefixe queues | `monkapi` |
| `QUEUE_DEFAULT_ATTEMPTS` | Tentatives | `3` |
| `QUEUE_DEFAULT_BACKOFF` | Delai retry (ms) | `5000` |

```env
QUEUE_PREFIX=monkapi
QUEUE_DEFAULT_ATTEMPTS=3
QUEUE_DEFAULT_BACKOFF=5000
```

## Rate Limiting

| Variable | Description | Defaut |
|----------|-------------|--------|
| `THROTTLE_TTL` | Fenetre (sec) | `60` |
| `THROTTLE_LIMIT` | Limite requetes | `100` |

```env
THROTTLE_TTL=60
THROTTLE_LIMIT=100
```

## Logging

| Variable | Description | Defaut |
|----------|-------------|--------|
| `LOG_LEVEL` | Niveau de log | `info` |
| `LOG_FORMAT` | Format (json/pretty) | `json` |

```env
LOG_LEVEL=info
LOG_FORMAT=json
```

Niveaux: `error`, `warn`, `info`, `debug`, `verbose`

## CORS

| Variable | Description | Defaut |
|----------|-------------|--------|
| `CORS_ORIGIN` | Origines autorisees | `*` |
| `CORS_METHODS` | Methodes HTTP | `GET,POST,PUT,DELETE` |

```env
CORS_ORIGIN=https://app.monkapi.com,https://admin.monkapi.com
CORS_METHODS=GET,POST,PUT,DELETE,PATCH,OPTIONS
```

## Swagger

| Variable | Description | Defaut |
|----------|-------------|--------|
| `SWAGGER_ENABLED` | Activer Swagger | `true` |
| `SWAGGER_PATH` | Chemin docs | `api/docs` |
| `SWAGGER_TITLE` | Titre | `MonkAPI` |

```env
SWAGGER_ENABLED=true
SWAGGER_PATH=api/docs
SWAGGER_TITLE=MonkAPI Documentation
```

**Important**: Desactiver en production publique.

## Sentry (Error Tracking)

| Variable | Description | Requis |
|----------|-------------|--------|
| `SENTRY_DSN` | DSN Sentry | Non |
| `SENTRY_ENVIRONMENT` | Environnement | Non |

```env
SENTRY_DSN=https://xxx@sentry.io/xxx
SENTRY_ENVIRONMENT=production
```

---

## Configuration par environnement

### Development

```env
NODE_ENV=development
LOG_LEVEL=debug
DATABASE_LOG_QUERIES=true
SWAGGER_ENABLED=true
```

### Staging

```env
NODE_ENV=staging
LOG_LEVEL=info
DATABASE_LOG_QUERIES=false
SWAGGER_ENABLED=true
```

### Production

```env
NODE_ENV=production
LOG_LEVEL=warn
DATABASE_LOG_QUERIES=false
SWAGGER_ENABLED=false
SENTRY_DSN=https://...
```

---

## Secrets Kubernetes

Pour Kubernetes, stocker les secrets dans un Secret:

```yaml
apiVersion: v1
kind: Secret
metadata:
  name: monkapi-secret
type: Opaque
stringData:
  DATABASE_URL: "mysql://..."
  JWT_SECRET: "..."
  STRIPE_SECRET_KEY: "sk_live_..."
```

Ne jamais commiter de secrets dans le code source.
