# MonkAPI - Node.js Backend

> Backend API pour application VTC/Ride-hailing migre de Laravel vers NestJS

[![CI](https://github.com/monkapi/api/actions/workflows/ci.yml/badge.svg)](https://github.com/monkapi/api/actions/workflows/ci.yml)
[![License](https://img.shields.io/badge/license-MIT-blue.svg)](LICENSE)

## Table des matieres

- [Apercu](#apercu)
- [Technologies](#technologies)
- [Prerequis](#prerequis)
- [Installation](#installation)
- [Configuration](#configuration)
- [Demarrage](#demarrage)
- [Structure du projet](#structure-du-projet)
- [Documentation API](#documentation-api)
- [Tests](#tests)
- [Deploiement](#deploiement)
- [Scripts disponibles](#scripts-disponibles)
- [Documentation](#documentation)

## Apercu

MonkAPI est une plateforme backend complete pour applications de VTC (Voiture de Transport avec Chauffeur) et services de livraison. Elle gere:

- **Authentification** - JWT, OAuth social (Google, Facebook, Apple), OTP
- **Reservations** - Creation, assignation, suivi temps reel
- **Chauffeurs** - Profils, documents, localisation GPS, gains
- **Paiements** - Stripe, PayPal, Mobile Money, 50+ passerelles
- **Livraisons** - Multi-stops, suivi colis
- **Notifications** - FCM, OneSignal, SMS, WhatsApp, Email
- **Multi-tenant** - Isolation par merchant_id

## Technologies

| Technologie | Version | Description |
|-------------|---------|-------------|
| Node.js | 20.x | Runtime JavaScript |
| NestJS | 10.x | Framework backend |
| Prisma | 5.x | ORM base de donnees |
| MySQL | 8.x | Base de donnees |
| Redis | 7.x | Cache & queues |
| Socket.io | 4.x | WebSockets temps reel |
| BullMQ | 4.x | Gestion des jobs |
| Swagger | 7.x | Documentation API |

## Prerequis

- Node.js >= 20.0.0
- pnpm >= 8.0.0
- MySQL >= 8.0
- Redis >= 7.0
- Docker (optionnel)

## Installation

### Avec pnpm (recommande)

```bash
# Cloner le repository
git clone https://github.com/monkapi/api.git
cd monkapi-node

# Installer les dependances
pnpm install

# Copier la configuration
cp .env.example .env

# Generer le client Prisma
pnpm prisma generate

# Appliquer les migrations
pnpm prisma migrate dev

# Seeder la base de donnees
pnpm db:seed
```

### Avec Docker

```bash
# Demarrer tous les services
docker-compose up -d

# Voir les logs
docker-compose logs -f api
```

## Configuration

Editer le fichier `.env` avec vos parametres:

```env
# Application
NODE_ENV=development
PORT=3000
API_VERSION=v1

# Base de donnees
DATABASE_URL="mysql://user:password@localhost:3306/monkapi"

# Redis
REDIS_HOST=localhost
REDIS_PORT=6379

# JWT
JWT_SECRET=your-super-secret-key
JWT_EXPIRES_IN=7d
JWT_REFRESH_SECRET=your-refresh-secret
JWT_REFRESH_EXPIRES_IN=30d

# Stripe
STRIPE_SECRET_KEY=sk_test_xxx
STRIPE_WEBHOOK_SECRET=whsec_xxx

# Firebase
FIREBASE_PROJECT_ID=your-project
FIREBASE_PRIVATE_KEY=xxx
FIREBASE_CLIENT_EMAIL=xxx

# AWS S3
AWS_ACCESS_KEY_ID=xxx
AWS_SECRET_ACCESS_KEY=xxx
AWS_S3_BUCKET=monkapi-uploads
AWS_REGION=eu-west-1
```

Voir [docs/configuration.md](docs/configuration.md) pour la liste complete.

## Demarrage

```bash
# Mode developpement (hot reload)
pnpm start:dev

# Mode production
pnpm build
pnpm start:prod

# Mode debug
pnpm start:debug
```

L'API sera disponible sur `http://localhost:3000`

## Structure du projet

```
monkapi-node/
├── src/
│   ├── main.ts                 # Point d'entree
│   ├── app.module.ts           # Module racine
│   ├── config/                 # Configuration
│   │   ├── app.config.ts
│   │   ├── database.config.ts
│   │   ├── jwt.config.ts
│   │   └── redis.config.ts
│   ├── common/                 # Code partage
│   │   ├── decorators/         # @Public, @MerchantId, @CurrentUser
│   │   ├── dto/                # DTOs communs
│   │   ├── exceptions/         # Exceptions personnalisees
│   │   ├── filters/            # Exception filters
│   │   ├── guards/             # Auth guards
│   │   ├── interceptors/       # Response interceptor
│   │   ├── prisma/             # Service Prisma
│   │   ├── constants/          # Constantes
│   │   └── utils/              # Fonctions utilitaires
│   ├── modules/                # Modules metier
│   │   ├── auth/               # Authentification
│   │   ├── user/               # Utilisateurs
│   │   ├── driver/             # Chauffeurs
│   │   ├── booking/            # Reservations
│   │   ├── payment/            # Paiements
│   │   ├── delivery/           # Livraisons
│   │   ├── notification/       # Notifications
│   │   ├── chat/               # Messagerie
│   │   ├── rating/             # Notes & avis
│   │   ├── promo/              # Codes promo
│   │   ├── wallet/             # Portefeuille
│   │   ├── vehicle/            # Vehicules
│   │   ├── zone/               # Zones geographiques
│   │   ├── surge/              # Tarification dynamique
│   │   ├── handyman/           # Services a domicile
│   │   ├── corporate/          # Comptes entreprise
│   │   ├── franchise/          # Franchises
│   │   └── ...                 # 47 modules au total
│   └── shared/                 # Services partages
│       ├── cache/              # Service cache Redis
│       ├── queue/              # Service queues BullMQ
│       ├── storage/            # Service stockage S3
│       ├── mail/               # Service email
│       └── sms/                # Service SMS
├── prisma/
│   ├── schema.prisma           # Schema base de donnees (60 models)
│   └── seed.ts                 # Donnees initiales
├── test/
│   ├── setup.ts                # Configuration tests
│   ├── *.spec.ts               # Tests unitaires
│   └── *.e2e-spec.ts           # Tests E2E
├── k8s/                        # Kubernetes configs
├── scripts/                    # Scripts utilitaires
├── docs/                       # Documentation
├── Dockerfile
├── docker-compose.yml
└── package.json
```

## Documentation API

### Swagger UI

Une fois l'application demarree, accedez a:

- **Swagger UI**: http://localhost:3000/api/docs
- **JSON OpenAPI**: http://localhost:3000/api/docs-json
- **YAML OpenAPI**: http://localhost:3000/api/docs-yaml

### Endpoints principaux

| Methode | Endpoint | Description |
|---------|----------|-------------|
| POST | `/api/v1/auth/signup` | Inscription utilisateur |
| POST | `/api/v1/auth/login` | Connexion |
| POST | `/api/v1/auth/login-otp` | Connexion OTP |
| POST | `/api/v1/auth/refresh` | Rafraichir token |
| GET | `/api/v1/user/profile` | Profil utilisateur |
| POST | `/api/v1/booking/estimate` | Estimation course |
| POST | `/api/v1/booking/create` | Creer reservation |
| GET | `/api/v1/booking/:id` | Details reservation |
| PUT | `/api/v1/driver/location` | MAJ position chauffeur |
| POST | `/api/v1/payment/methods` | Ajouter moyen paiement |

Voir [docs/api.md](docs/api.md) pour la documentation complete.

## Tests

```bash
# Tests unitaires
pnpm test

# Tests avec coverage
pnpm test:cov

# Tests E2E
pnpm test:e2e

# Tests en mode watch
pnpm test:watch
```

## Deploiement

### Docker

```bash
# Build l'image
docker build -t monkapi/api:latest .

# Lancer le conteneur
docker run -p 3000:3000 --env-file .env monkapi/api:latest
```

### Kubernetes

```bash
# Appliquer les configurations
kubectl apply -f k8s/namespace.yaml
kubectl apply -f k8s/configmap.yaml
kubectl apply -f k8s/secret.yaml
kubectl apply -f k8s/deployment.yaml
kubectl apply -f k8s/service.yaml
kubectl apply -f k8s/hpa.yaml
kubectl apply -f k8s/redis.yaml
```

Voir [docs/deployment.md](docs/deployment.md) pour plus de details.

## Scripts disponibles

| Commande | Description |
|----------|-------------|
| `pnpm start:dev` | Demarrer en mode developpement |
| `pnpm start:prod` | Demarrer en mode production |
| `pnpm build` | Compiler TypeScript |
| `pnpm test` | Lancer les tests |
| `pnpm test:cov` | Tests avec coverage |
| `pnpm test:e2e` | Tests end-to-end |
| `pnpm lint` | Verifier le code |
| `pnpm format` | Formatter le code |
| `pnpm prisma generate` | Generer client Prisma |
| `pnpm prisma migrate dev` | Appliquer migrations |
| `pnpm prisma studio` | Interface Prisma |
| `pnpm db:seed` | Seeder la base |

## Documentation

- [Architecture](docs/architecture.md)
- [Configuration](docs/configuration.md)
- [API Reference](docs/api.md)
- [Modules](docs/modules.md)
- [Deploiement](docs/deployment.md)
- [Contributing](docs/contributing.md)

## License

MIT License - voir [LICENSE](LICENSE) pour plus de details.
