# Déploiement MonkAPI Node.js sur cPanel

## Prérequis
- cPanel avec Node.js Selector (CloudLinux)
- Accès SSH ou Terminal cPanel
- MySQL déjà configuré (base Laravel existante)

---

## Étape 1: Uploader le code

### Option A: Via File Manager cPanel
1. Compresser le dossier `monkapi-node` en ZIP
2. Dans cPanel > File Manager > public_html
3. Créer un dossier `monkapijs` (ou utiliser le domaine)
4. Uploader et extraire le ZIP

### Option B: Via SSH/Terminal
```bash
cd ~/public_html
git clone [votre-repo] monkapijs
# OU
scp -r monkapi-node/ user@178.18.249.70:~/public_html/monkapijs
```

---

## Étape 2: Configurer Node.js sur cPanel

1. cPanel > **Setup Node.js App**
2. Cliquer **Create Application**
3. Configuration:
   - **Node.js version**: 20.x (ou 18.x)
   - **Application mode**: Production
   - **Application root**: `/home/USERNAME/public_html/monkapijs`
   - **Application URL**: `monkapijs.monkapi.com`
   - **Application startup file**: `dist/main.js`
4. Cliquer **Create**

---

## Étape 3: Configurer les variables d'environnement

Dans Node.js App > **Edit** > **Environment Variables**, ajouter:

```
NODE_ENV = production
PORT = 3000
DATABASE_URL = mysql://USER:PASS@localhost:3306/monkapi
JWT_SECRET = votre-clé-secrète
JWT_REFRESH_SECRET = votre-clé-refresh
REDIS_HOST = localhost
REDIS_PORT = 6379
```

**IMPORTANT**: Copier les clés API depuis votre `.env` Laravel:
- PUSHER_*
- FIREBASE_*
- STRIPE_*
- TWILIO_*
- AWS_*

---

## Étape 4: Installer et compiler

1. Dans Node.js App, cliquer **Run NPM Install**

   OU via SSH:
   ```bash
   cd ~/public_html/monkapijs
   source /home/USERNAME/nodevenv/monkapijs/20/bin/activate
   npm install
   npx prisma generate
   npm run build
   ```

2. Vérifier que le dossier `dist/` est créé

---

## Étape 5: Démarrer l'application

1. Dans cPanel Node.js App, cliquer **Start App**
2. Vérifier le statut: devrait être "Running"

---

## Étape 6: Configurer le domaine (si pas déjà fait)

1. cPanel > **Domains** ou **Subdomains**
2. Créer: `monkapijs.monkapi.com`
3. Document Root: `/home/USERNAME/public_html/monkapijs/public`

---

## Étape 7: Tester

```bash
curl https://monkapijs.monkapi.com/api/health
```

Réponse attendue:
```json
{"status":"ok","timestamp":"..."}
```

---

## Dépannage

### Erreur "Cannot find module"
```bash
npm run build
```

### Erreur de connexion DB
Vérifier DATABASE_URL dans les variables d'environnement

### Port déjà utilisé
cPanel gère automatiquement le port, pas besoin de 3000

### Logs
```bash
# Via SSH
tail -f ~/public_html/monkapijs/logs/error.log
# OU
cPanel > Metrics > Errors
```

---

## Structure des fichiers sur le serveur

```
/home/USERNAME/
├── public_html/
│   └── monkapijs/
│       ├── dist/          ← Application compilée
│       ├── node_modules/
│       ├── prisma/
│       ├── .env           ← Variables (ou via cPanel)
│       └── package.json
└── nodevenv/
    └── monkapijs/
        └── 20/            ← Environnement Node.js
```

---

## Commandes utiles

```bash
# Activer l'environnement Node
source /home/USERNAME/nodevenv/monkapijs/20/bin/activate

# Voir les logs
pm2 logs

# Redémarrer
pm2 restart all

# Status
pm2 status
```
